#include <GUIConstants.au3>
#include <GDIPlus.au3>
#include <Math.au3>

$hGUI = GUICreate("scintilla4evr's Cookbook of Examples - Quadrilateral Distortion (2016)", 600, 400)
GUISetBkColor(0xFFFFFF)
GUISetState()

_GDIPlus_Startup()

$hGpx = _GDIPlus_GraphicsCreateFromHWND($hGUI)
$hBufBmp = _GDIPlus_BitmapCreateFromScan0(600, 400)
$hBufGpx = _GDIPlus_ImageGetGraphicsContext($hBufBmp)
_GDIPlus_GraphicsSetSmoothingMode($hBufGpx, 5)
_GDIPlus_GraphicsClear($hBufGpx, 0xFFFFFFFF)

$hPath = _GDIPlus_PathCreate()

$hFamily = _GDIPlus_FontFamilyCreate("Arial") ;Create font family object
$tLayout = _GDIPlus_RectFCreate()

_GDIPlus_PathAddString($hPath, "Lorem ipsum", $tLayout, $hFamily, 0, 72)

$hCurvedText = _GDIPlus_PathCreate()

Global $aDist = [[50, 50], [400, 100], [30, 400], [600, 300]]

_QuadrilateralDistortion($hPath, $hCurvedText, $aDist)

_Render()

While 1
	Switch GUIGetMsg()
		Case $GUI_EVENT_CLOSE
			ExitLoop
	EndSwitch
WEnd

_GDIPlus_PathDispose($hCurvedText)

_GDIPlus_FontFamilyDispose($hFamily)
_GDIPlus_PathDispose($hPath)

_GDIPlus_GraphicsDispose($hBufGpx)
_GDIPlus_BitmapDispose($hBufBmp)
_GDIPlus_GraphicsDispose($hGpx)

_GDIPlus_Shutdown()

Func _Render()
	_GDIPlus_GraphicsClear($hBufGpx, 0xFFFFFFFF)

	_GDIPlus_GraphicsFillPath($hBufGpx, $hCurvedText)

	_GDIPlus_GraphicsDrawImage($hGpx, $hBufBmp, 0, 0)
EndFunc

Func _QuadrilateralDistortion($hText, $hOut, $aDist)
	$aTxtBounds = _GDIPlus_PathGetWorldBounds($hText)

	$hSub = _GDIPlus_PathCreate()

	$hIter = _GDIPlus_PathIterCreate($hText)

	For $i = 1 To _GDIPlus_PathIterGetSubpathCount($hIter)
		_GDIPlus_PathReset($hSub)
		_GDIPlus_PathIterNextSubpathPath($hIter, $hSub)

		$aPoints = _GDIPlus_PathGetData($hSub)
		For $n = 1 To $aPoints[0][0]
			$x = $aPoints[$n][0]-$aTxtBounds[0]
			$y = $aPoints[$n][1]-$aTxtBounds[1]

			$x = _Min($x/$aTxtBounds[2], 1)
			$y = _Min($y/$aTxtBounds[3], 1)

			; see: Case Study
			$C1x = _Lerp($x, $aDist[0][0], $aDist[1][0])
			$C1y = _Lerp($x, $aDist[0][1], $aDist[1][1])
			$C2x = _Lerp($x, $aDist[2][0], $aDist[3][0])
			$C2y = _Lerp($x, $aDist[2][1], $aDist[3][1])

			$aPoints[$n][0] = _Lerp($y, $C1x, $C2x)
			$aPoints[$n][1] = _Lerp($y, $C1y, $C2y)
		Next
		$hTrans = _GDIPlus_PathCreate2($aPoints)
		_GDIPlus_PathAddPath($hOut, $hTrans, False)
		_GDIPlus_PathDispose($hTrans)
	Next

	_GDIPlus_PathIterDispose($hIter)

	_GDIPlus_PathDispose($hSub)
EndFunc

Func _Lerp($x, $a, $b)
	Return $x*($b-$a) + $a
EndFunc
